/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.BackupExistingSDK;
import com.quantumdata.quantumdatasdk.CheckExistence;
import com.quantumdata.quantumdatasdk.MainScreen;
import com.quantumdata.quantumdatasdk.PromptForUpgrade;
import com.quantumdata.quantumdatasdk.ScreenManager;
import com.quantumdata.quantumdatasdk.StartWizardScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class StateMachine
implements ActionListener {
    private static final long serialVersionUID = -7614414677488821641L;
    private StartWizardScreen aStartWizardScreen;
    private MainScreen aMainScreen;
    private BackupExistingSDK aBackupExistingSDK;
    private int aCurrentState;

    public StateMachine() {
        this.init_vars();
    }

    private void init_vars() {
        this.aCurrentState = CheckExistence.isDefaultSDKInstalled() ? (CheckExistence.isDefaultSDKLatest() ? 2 : PromptForUpgrade.run(null)) : 0;
    }

    public void run() {
        switch (this.aCurrentState) {
            case 0: {
                this.aStartWizardScreen = new StartWizardScreen(this);
                break;
            }
            case 1: {
                ScreenManager screenManager = new ScreenManager();
                screenManager.run();
                break;
            }
            case 2: {
                this.aMainScreen = new MainScreen(this);
                break;
            }
            case 3: {
                this.aBackupExistingSDK = new BackupExistingSDK(this);
                break;
            }
            default: {
                System.err.println("Invalid State:  ID=" + this.aCurrentState);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.aCurrentState;
        switch (this.aCurrentState) {
            case 0: {
                n = this.aStartWizardScreen.ScreenHandler(actionEvent, this.aCurrentState);
                break;
            }
            case 2: {
                this.aMainScreen.actionPerformed(actionEvent);
                break;
            }
            case 3: {
                n = this.aBackupExistingSDK.ScreenHandler(actionEvent, this.aCurrentState);
                break;
            }
            default: {
                System.err.println("Invalid State:  ID=" + this.aCurrentState);
            }
        }
        if (this.isValidState(n) && n != this.aCurrentState) {
            this.free(this.aCurrentState);
            this.aCurrentState = n;
            this.run();
        }
    }

    public boolean isValidState(int n) {
        boolean bl = false;
        if (n >= 1 && n <= 3) {
            bl = true;
        }
        return bl;
    }

    public void free(int n) {
        switch (n) {
            case 0: {
                this.aStartWizardScreen.setVisible(false);
                break;
            }
            case 2: {
                this.aMainScreen.setVisible(false);
                break;
            }
            case 3: {
                this.aBackupExistingSDK.setVisible(false);
                break;
            }
            default: {
                System.err.println("Invalid State:  ID=" + this.aCurrentState);
            }
        }
        System.gc();
    }
}

